/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.items;

import code.elix_x.excore.utils.items.ItemCount;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ItemStackStringTranslator {
    public static final String NULL = "NULL";
    public static final String OREDICT = "oreDict";

    public static String toString(ItemStack itemstack) {
        return itemstack == null ? NULL : Item.field_150901_e.func_177774_c((Object)itemstack.func_77973_b()) + (itemstack.func_77952_i() == Short.MAX_VALUE ? "" : "/" + itemstack.func_77952_i());
    }

    public static ItemStack fromString(String string) {
        if (string.equals(NULL)) {
            return null;
        }
        try {
            Item item;
            if (string.split(":").length == 1) {
                string = "minecraft:" + string;
            }
            String[] modidId = string.split(":");
            String modid = modidId[0];
            String id = modidId[1];
            String[] idMeta = id.split("/");
            int meta = Short.MAX_VALUE;
            if (idMeta.length == 2) {
                id = idMeta[0];
                meta = Integer.parseInt(idMeta[1]);
            }
            if ((item = GameRegistry.findItem((String)modid, (String)id)) != null) {
                return new ItemStack(item, 1, meta);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not initalize item stack. Invalid argument was given: " + string, e);
        }
        throw new IllegalArgumentException("Could not initalize item stack. Invalid argument was given: " + string);
    }

    public static String toStringAdvanced(Object o) {
        if (o == null) {
            return NULL;
        }
        if (o instanceof ItemStack) {
            return ItemStackStringTranslator.toString((ItemStack)o);
        }
        if (o instanceof ItemCount) {
            return ItemStackStringTranslator.toString(((ItemCount)o).toItemstack());
        }
        if (o instanceof Item) {
            return ItemStackStringTranslator.toString(new ItemStack((Item)o, 1, Short.MAX_VALUE));
        }
        if (o instanceof Block) {
            return ItemStackStringTranslator.toString(new ItemStack((Block)o, 1, Short.MAX_VALUE));
        }
        if (o instanceof String) {
            return "oreDict:" + o;
        }
        throw new IllegalArgumentException("Illegal argument: " + o);
    }

    public static Object fromStringAdvanced(String s) {
        if (s.equals(NULL)) {
            return null;
        }
        if (s.split(":").length == 1) {
            s = "minecraft:" + s;
        }
        if (s.split(":")[0].equals(OREDICT)) {
            return s.split(":")[1];
        }
        return ItemStackStringTranslator.fromString(s);
    }

    public static boolean isValidItemstack(String s) {
        try {
            ItemStackStringTranslator.fromString(s);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidItemstackAdvanced(String s) {
        try {
            ItemStackStringTranslator.fromStringAdvanced(s);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

