/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.mods.fei.client.gui.element;

import code.elix_x.excore.utils.client.gui.elements.IGuiElement;
import code.elix_x.excore.utils.client.gui.elements.ListGuiElement;
import code.elix_x.excore.utils.client.gui.elements.RectangularGuiElement;
import code.elix_x.excore.utils.color.RGBA;
import code.elix_x.mods.fei.api.gui.FEIGuiOverride;
import code.elix_x.mods.fei.api.gui.elements.IConfigurableFEIGuiElement;
import code.elix_x.mods.fei.api.gui.elements.ISaveableFEIGuiElement;
import code.elix_x.mods.fei.api.profile.Profile;
import code.elix_x.mods.fei.client.gui.FEIModsItemsDropdownSettingsGui;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import mezz.jei.Internal;
import mezz.jei.gui.ingredients.ItemStackRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.common.registry.GameData;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Rectangle;

public class FEIModsItemsDropdown
extends RectangularGuiElement<FEIGuiOverride>
implements ISaveableFEIGuiElement,
IConfigurableFEIGuiElement {
    public static final Gson gson = new Gson();
    private Multimap<String, ItemStack> modItemsMap;
    private ModsListGuiElement modsList;
    private ItemsListGuiElement itemsList;
    protected int clickTimeThreshold = 250;
    protected int clickDistanceThreshold = 2;
    public RGBA backgroundColor = new RGBA(0, 0, 0, 0);
    public RGBA textColor = new RGBA(1.0f, 1.0f, 1.0f, 1.0f);
    public boolean tooltipBackground = false;
    public int dropdownSize = 128;
    public boolean focused;

    public FEIModsItemsDropdown() {
        super("FEI Mods Items Dropdown", 60, 0, 20, 100, 2, 2);
        this.modItemsMap = TreeMultimap.create((Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        }, (Comparator)new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack e1, ItemStack e2) {
                int iid = GameData.getItemRegistry().getId((Object)e2.func_77973_b()) - GameData.getItemRegistry().getId((Object)e1.func_77973_b());
                return iid == 0 ? (e2.func_77952_i() - e1.func_77952_i() < 0 ? 1 : -1) : (iid < 0 ? 1 : -1);
            }
        });
        for (Item item : GameData.getItemRegistry()) {
            if (item == null) continue;
            ArrayList<ItemStack> subItems = new ArrayList<ItemStack>();
            try {
                item.func_150895_a(item, null, subItems);
            }
            catch (NullPointerException e) {
                subItems.add(new ItemStack(item));
            }
            this.modItemsMap.putAll((Object)GameData.getItemRegistry().getNameForObject((Object)item).func_110624_b(), subItems);
        }
        this.modsList = new ModsListGuiElement();
    }

    public int getHeight() {
        return this.focused ? super.getHeight() + this.borderX + this.dropdownSize + this.borderX : super.getHeight();
    }

    public int getFoldedHeight() {
        return super.getHeight();
    }

    public void reInitModsList() {
        this.modsList = new ModsListGuiElement();
    }

    public Rectangle toFoldedRectangle() {
        Rectangle rect = super.toRectangle();
        if (this.focused) {
            rect.setHeight(super.getHeight());
        }
        return rect;
    }

    @Override
    public void load(Profile profile, JsonObject json) {
        JsonData data = (JsonData)gson.fromJson((JsonElement)json, JsonData.class);
        this.xPos = data.xPos;
        this.yPos = data.yPos;
        this.width = data.width;
        this.height = data.height;
        this.borderX = data.borderX;
        this.borderY = data.borderY;
        this.clickTimeThreshold = data.clickTimeThreshold;
        this.clickDistanceThreshold = data.clickDistanceThreshold;
        this.backgroundColor = data.backgroundColor;
        this.textColor = data.textColor;
        this.tooltipBackground = data.tooltipBackground;
        this.dropdownSize = data.dropdownSize;
        this.modsList = new ModsListGuiElement();
    }

    @Override
    public JsonObject save(Profile profile) {
        JsonData data = new JsonData();
        data.xPos = this.xPos;
        data.yPos = this.yPos;
        data.width = this.width;
        data.height = this.height;
        data.borderX = this.borderX;
        data.borderY = this.borderY;
        data.clickTimeThreshold = this.clickTimeThreshold;
        data.clickDistanceThreshold = this.clickDistanceThreshold;
        data.backgroundColor = this.backgroundColor;
        data.textColor = this.textColor;
        data.tooltipBackground = this.tooltipBackground;
        data.dropdownSize = this.dropdownSize;
        return gson.toJsonTree((Object)data).getAsJsonObject();
    }

    @Override
    public String getUnlocalizedName() {
        return "fei.gui.override.dropdown.modsitems";
    }

    @Override
    public void openConfigGui(GuiScreen parent, FEIGuiOverride fei) {
        parent.field_146297_k.func_147108_a((GuiScreen)new FEIModsItemsDropdownSettingsGui(parent, this));
    }

    public void openGui(FEIGuiOverride fei, GuiScreen gui) {
    }

    public void initGui(FEIGuiOverride fei, GuiScreen gui) {
    }

    public void drawGuiPre(FEIGuiOverride fei, GuiScreen gui, int mouseX, int mouseY) {
        if (this.focused) {
            this.modsList.drawGuiPre(fei, gui, mouseX, mouseY);
            if (this.itemsList != null) {
                this.itemsList.drawGuiPre(fei, gui, mouseX, mouseY);
            }
        }
    }

    public void drawBackground(FEIGuiOverride fei, GuiScreen gui, int mouseX, int mouseY) {
    }

    public void drawGuiPost(FEIGuiOverride fei, GuiScreen gui, int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_175599_af().field_77023_b = 100.0f;
        GlStateManager.func_179097_i();
        this.renderItemStackPre();
        if (this.backgroundColor.a > 0) {
            this.fill(this.backgroundColor);
        }
        new GuiButtonExt(0, this.xPos + this.borderX, this.yPos + this.borderY, this.width, this.getFoldedHeight() - this.borderY - this.borderY, StatCollector.func_74838_a((String)"fei.gui.override.dropdown.modsitems.mods")).func_146112_a(gui.field_146297_k, mouseX, mouseY);
        if (this.focused) {
            this.modsList.drawGuiPost(fei, gui, mouseX, mouseY);
            if (this.itemsList != null) {
                this.itemsList.drawGuiPost(fei, gui, mouseX, mouseY);
            }
        }
        this.renderItemStackPost();
        GlStateManager.func_179126_j();
    }

    public void drawGuiPostPost(FEIGuiOverride fei, GuiScreen gui, int mouseX, int mouseY) {
        if (this.focused) {
            this.modsList.drawGuiPostPost(fei, gui, mouseX, mouseY);
            if (this.itemsList != null) {
                this.itemsList.drawGuiPostPost(fei, gui, mouseX, mouseY);
            }
        }
    }

    public boolean handleKeyboardEvent(FEIGuiOverride fei, GuiScreen gui, boolean down, int key, char c) {
        return false;
    }

    public boolean handleMouseEvent(FEIGuiOverride fei, GuiScreen gui, int mouseX, int mouseY, boolean down, int key) {
        if (down) {
            if (key == 0) {
                if (this.itemsList != null && !this.itemsList.inside(mouseX, mouseY)) {
                    this.itemsList = null;
                    return true;
                }
                if (this.itemsList == null && this.focused && !this.modsList.inside(mouseX, mouseY)) {
                    this.focused = false;
                    fei.looseFocus();
                    return true;
                }
            }
            if (this.itemsList == null && !this.focused && this.inside(mouseX, mouseY) && mouseY <= this.yPos + this.borderY + 20 + this.borderY && key == 0) {
                this.focused = true;
                fei.setFocused((IGuiElement<FEIGuiOverride>)this);
                return true;
            }
        }
        if (this.itemsList != null && this.itemsList.handleMouseEvent(fei, gui, mouseX, mouseY, down, key)) {
            return true;
        }
        return this.focused && this.modsList.handleMouseEvent(fei, gui, mouseX, mouseY, down, key);
    }

    public boolean handleMouseEvent(FEIGuiOverride fei, GuiScreen gui, int mouseX, int mouseY, int dWheel) {
        if (this.itemsList != null && this.itemsList.handleMouseEvent(fei, gui, mouseX, mouseY, dWheel)) {
            return true;
        }
        return this.focused && this.modsList.handleMouseEvent(fei, gui, mouseX, mouseY, dWheel);
    }

    public static class JsonData {
        private int xPos;
        private int yPos;
        private int width;
        private int height;
        private int borderX;
        private int borderY;
        private int clickTimeThreshold;
        private int clickDistanceThreshold;
        private RGBA backgroundColor;
        private RGBA textColor;
        private boolean tooltipBackground;
        private int dropdownSize;

        private JsonData() {
        }
    }

    public class ItemsListGuiElement
    extends ListGuiElement<FEIGuiOverride> {
        private ItemStackRenderer renderer;

        public ItemsListGuiElement(String mod) {
            super("Items List", FEIModsItemsDropdown.this.xPos + FEIModsItemsDropdown.this.getWidth() / 2 + FEIModsItemsDropdown.this.borderX, FEIModsItemsDropdown.this.yPos + FEIModsItemsDropdown.this.getFoldedHeight(), 16, FEIModsItemsDropdown.this.dropdownSize, 16, FEIModsItemsDropdown.this.borderX, FEIModsItemsDropdown.this.borderY, new RGBA(0, 0, 0, 0));
            this.renderer = new ItemStackRenderer();
            this.clickTimeThreshold = FEIModsItemsDropdown.this.clickTimeThreshold;
            this.clickDistanceThreshold = FEIModsItemsDropdown.this.clickDistanceThreshold;
            for (ItemStack itemstack : FEIModsItemsDropdown.this.modItemsMap.get((Object)mod)) {
                this.elements = (ListGuiElement.ListElement[])ArrayUtils.add((Object[])this.elements, (Object)((Object)new ItemsListElement(itemstack)));
            }
            Arrays.sort(this.elements, new Comparator<ListGuiElement.ListElement>(){

                @Override
                public int compare(ListGuiElement.ListElement o1, ListGuiElement.ListElement o2) {
                    ItemsListElement e1 = (ItemsListElement)o1;
                    ItemsListElement e2 = (ItemsListElement)o2;
                    int iid = GameData.getItemRegistry().getId((Object)e2.itemstack.func_77973_b()) - GameData.getItemRegistry().getId((Object)e1.itemstack.func_77973_b());
                    return iid == 0 ? (e2.itemstack.func_77952_i() - e1.itemstack.func_77952_i() < 0 ? 1 : -1) : (iid < 0 ? 1 : -1);
                }
            });
        }

        public class ItemsListElement
        extends ListGuiElement.ListElement {
            private ItemStack itemstack;

            public ItemsListElement(ItemStack itemstack) {
                super((ListGuiElement)ItemsListGuiElement.this);
                this.itemstack = itemstack;
            }

            public void drawGuiPost(FEIGuiOverride fei, GuiScreen gui, int index, int x, int relY, int mouseX, int mouseY) {
                GlStateManager.func_179126_j();
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.0, (double)0.0, (double)10.0);
                ItemsListGuiElement.this.renderer.draw(gui.field_146297_k, x, relY, this.itemstack);
                GL11.glPopMatrix();
                GlStateManager.func_179097_i();
            }

            public void drawGuiPostPost(FEIGuiOverride fei, GuiScreen gui, int index, int x, int relY, int mouseX, int mouseY) {
                if (this.inside(relY, mouseX, mouseY)) {
                    if (gui.func_146272_n()) {
                        ItemsListGuiElement.this.scissorsPost();
                        ItemsListGuiElement.this.drawTooltip(ItemsListGuiElement.this.renderer.getFontRenderer(gui.field_146297_k, this.itemstack), mouseX, mouseY, false, true, 2, FEIModsItemsDropdown.this.textColor, FEIModsItemsDropdown.this.tooltipBackground, false, ItemsListGuiElement.this.renderer.getTooltip(gui.field_146297_k, this.itemstack).toArray(new String[0]));
                        ItemsListGuiElement.this.scissorsPre();
                    } else {
                        ItemsListGuiElement.this.scissorsPost();
                        ItemsListGuiElement.this.drawTooltip(ItemsListGuiElement.this.renderer.getFontRenderer(gui.field_146297_k, this.itemstack), mouseX, mouseY, false, true, 0, FEIModsItemsDropdown.this.textColor, FEIModsItemsDropdown.this.tooltipBackground, false, new String[]{this.itemstack.func_82833_r()});
                        ItemsListGuiElement.this.scissorsPre();
                    }
                }
            }
        }
    }

    public class ModsListGuiElement
    extends ListGuiElement<FEIGuiOverride> {
        public ModsListGuiElement() {
            super("Mods List", FEIModsItemsDropdown.this.xPos + FEIModsItemsDropdown.this.borderX, FEIModsItemsDropdown.this.yPos + FEIModsItemsDropdown.this.getFoldedHeight(), FEIModsItemsDropdown.this.width / 2, FEIModsItemsDropdown.this.dropdownSize, 20, FEIModsItemsDropdown.this.borderX, FEIModsItemsDropdown.this.borderY, new RGBA(0, 0, 0, 0));
            this.clickTimeThreshold = FEIModsItemsDropdown.this.clickTimeThreshold;
            this.clickDistanceThreshold = FEIModsItemsDropdown.this.clickDistanceThreshold;
            for (String s : FEIModsItemsDropdown.this.modItemsMap.keySet()) {
                this.add(new ModsListElement(s));
            }
        }

        public class ModsListElement
        extends ListGuiElement.ListElement {
            private String mod;

            public ModsListElement(String mod) {
                super((ListGuiElement)ModsListGuiElement.this);
                this.mod = mod;
            }

            public void drawGuiPost(FEIGuiOverride fei, GuiScreen gui, int index, int x, int relY, int mouseX, int mouseY) {
                ModsListGuiElement.this.drawColoredRect(new Rectangle(x, relY, 10, 10), new RGBA(0, 255, 0), 100.0);
                new GuiButtonExt(0, x, relY, ModsListGuiElement.this.width, ModsListGuiElement.this.elementY, this.mod).func_146112_a(gui.field_146297_k, mouseX, mouseY);
            }

            public boolean handleMouseEvent(FEIGuiOverride fei, GuiScreen gui, int index, int x, int relY, int mouseX, int mouseY, boolean down, int key) {
                if (down && this.inside(relY, mouseX, mouseY)) {
                    if (key == 0) {
                        FEIModsItemsDropdown.this.itemsList = new ItemsListGuiElement(this.mod);
                        return true;
                    }
                    if (key == 1) {
                        Internal.getRuntime().getItemListOverlay().setFilterText(Internal.getRuntime().getItemListOverlay().getFilterText() + "@" + this.mod);
                    }
                }
                return false;
            }
        }
    }
}

