/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.mods.fei.api.permission;

public enum FEIPermissionLevel {
    USER(0),
    MODERATOR(1),
    ADMINISTRATOR(2),
    OWNER(3);

    private int level;

    public static String[] names() {
        return new String[]{USER.name(), MODERATOR.name(), ADMINISTRATOR.name(), OWNER.name()};
    }

    private FEIPermissionLevel(int level) {
        this.level = level;
    }

    public boolean isHigher(FEIPermissionLevel llevel) {
        return this.level > llevel.level;
    }

    public boolean isHigherOrEqual(FEIPermissionLevel llevel) {
        return this.level >= llevel.level;
    }

    public boolean isLower(FEIPermissionLevel llevel) {
        return this.level < llevel.level;
    }

    public boolean isLowerOrEqual(FEIPermissionLevel llevel) {
        return this.level <= llevel.level;
    }

    public boolean isUser() {
        return true;
    }

    public boolean isModerator() {
        return this.level > 0;
    }

    public boolean isAdmindistrator() {
        return this.level > 1;
    }
}

