/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.registry;

import alexndr.api.registry.BlockDetails;
import alexndr.api.registry.ContentCategories;
import alexndr.api.registry.ItemDetails;
import alexndr.api.registry.Plugin;
import alexndr.api.registry.TabDetails;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;

public class ContentRegistry {
    public static Class<BlockDetails> blockDetails = BlockDetails.class;
    public static Class<ItemDetails> itemDetails = ItemDetails.class;
    public static Class<TabDetails> tabDetails = TabDetails.class;
    private static List<Plugin> pluginList = Lists.newArrayList();
    private static List<BlockDetails> blockList = Lists.newArrayList();
    private static List<ItemDetails> itemList = Lists.newArrayList();
    private static List<TabDetails> tabList = Lists.newArrayList();

    public static void registerPlugin(Plugin plugin) {
        pluginList.add(plugin);
    }

    public static void registerBlock(Plugin plugin, Block block, String name, ContentCategories.Block category) {
        BlockDetails details = new BlockDetails(plugin, block, name, category);
        blockList.add(details);
        plugin.blocksList.add(details);
    }

    public static void registerItem(Plugin plugin, Item item, String name, ContentCategories.Item category) {
        ItemDetails details = new ItemDetails(plugin, item, name, category);
        itemList.add(details);
        plugin.itemsList.add(details);
    }

    public static void registerTab(Plugin plugin, CreativeTabs tab, String name, ContentCategories.CreativeTab category) {
        TabDetails details = new TabDetails(plugin, tab, name, category);
        tabList.add(details);
        plugin.tabsList.add(details);
    }

    public static boolean isPluginLoaded(String pluginName) {
        for (Plugin plugin : pluginList) {
            if (!plugin.getName().equals(pluginName)) continue;
            return true;
        }
        return false;
    }

    public static Plugin getPlugin(String pluginName) {
        for (Plugin plugin : pluginList) {
            if (!plugin.getName().equals(pluginName)) continue;
            return plugin;
        }
        return null;
    }

    public static List<Block> getPluginBlocks(String pluginName) {
        ArrayList list = Lists.newArrayList();
        Plugin plugin = ContentRegistry.getPlugin(pluginName);
        for (BlockDetails details : plugin.blocksList) {
            list.add(details.block);
        }
        return list;
    }

    public static List<Block> getPluginBlocks(String pluginName, ContentCategories.Block category) {
        ArrayList list = Lists.newArrayList();
        Plugin plugin = ContentRegistry.getPlugin(pluginName);
        for (BlockDetails details : plugin.blocksList) {
            if (details.category != category) continue;
            list.add(details.block);
        }
        return list;
    }

    public static List<Item> getPluginItems(String pluginName) {
        ArrayList list = Lists.newArrayList();
        Plugin plugin = ContentRegistry.getPlugin(pluginName);
        for (ItemDetails details : plugin.itemsList) {
            list.add(details.item);
        }
        return list;
    }

    public static List<Item> getPluginItems(String pluginName, ContentCategories.Item category) {
        ArrayList list = Lists.newArrayList();
        Plugin plugin = ContentRegistry.getPlugin(pluginName);
        for (ItemDetails details : plugin.itemsList) {
            if (details.category != category) continue;
            list.add(details.item);
        }
        return list;
    }

    public static List<CreativeTabs> getPluginTabs(String pluginName) {
        ArrayList list = Lists.newArrayList();
        Plugin plugin = ContentRegistry.getPlugin(pluginName);
        for (TabDetails details : plugin.tabsList) {
            list.add(details.tab);
        }
        return list;
    }

    public static List<CreativeTabs> getPluginTabs(String pluginName, ContentCategories.CreativeTab category) {
        ArrayList list = Lists.newArrayList();
        Plugin plugin = ContentRegistry.getPlugin(pluginName);
        for (TabDetails details : plugin.tabsList) {
            if (details.category != category) continue;
            list.add(details.tab);
        }
        return list;
    }

    public static boolean doesBlockExist(String blockName) {
        for (BlockDetails block : blockList) {
            if (!block.name.equals(blockName)) continue;
            return true;
        }
        return false;
    }

    public static Block getBlock(String blockName) {
        for (BlockDetails details : blockList) {
            if (!details.name.equals(blockName)) continue;
            return details.block;
        }
        return null;
    }

    public static boolean doesItemExist(String itemName) {
        for (ItemDetails item : itemList) {
            if (!item.name.equals(itemName)) continue;
            return true;
        }
        return false;
    }

    public static Item getItem(String itemName) {
        for (ItemDetails details : itemList) {
            if (!details.name.equals(itemName)) continue;
            return details.item;
        }
        return null;
    }

    public static boolean doesTabExist(String tabName) {
        for (TabDetails tab : tabList) {
            if (!tab.name.equals(tabName)) continue;
            return true;
        }
        return false;
    }

    public static CreativeTabs getTab(String tabName) {
        for (TabDetails details : tabList) {
            if (!details.name.equals(tabName)) continue;
            return details.tab;
        }
        return null;
    }

    public static CreativeTabs getFirstTabInCategory(ContentCategories.CreativeTab category) {
        for (TabDetails details : tabList) {
            if (details.category != category) continue;
            return details.tab;
        }
        return null;
    }
}

