/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.core;

import alexndr.api.content.inventory.SimpleTab;
import alexndr.api.core.APISettings;
import alexndr.api.core.ProxyCommon;
import alexndr.api.helpers.events.CommonEventHelper;
import alexndr.api.helpers.game.OreGenerator;
import alexndr.api.logger.LogHelper;
import alexndr.api.registry.ContentCategories;
import alexndr.api.registry.ContentRegistry;
import alexndr.api.registry.Plugin;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="simplecore", name="SimpleCore API", version="1.2.4.2", updateJSON="https://raw.githubusercontent.com/Sinhika/SimpleCore/dev1.8.9/update.json", acceptedMinecraftVersions="[1.8.9]")
public class SimpleCoreAPI {
    @SidedProxy(clientSide="alexndr.api.core.ProxyClient", serverSide="alexndr.api.core.ProxyCommon")
    public static ProxyCommon proxy;
    public static Plugin plugin;
    public static Plugin vanilla;
    public static List<List<Object>> bowRenderList;
    private static boolean iconsSet;
    private static SimpleTab simpleBlocks;
    private static SimpleTab simpleDecorations;
    private static SimpleTab simpleMaterials;
    private static SimpleTab simpleTools;
    private static SimpleTab simpleCombat;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LogHelper.info("SimpleCore API Loading...");
        MinecraftForge.EVENT_BUS.register((Object)new CommonEventHelper());
        proxy.registerEventHandlers();
        APISettings.createOrLoadSettings(event);
        LogHelper.loggerSetup();
        this.addVanillaTabs();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            proxy.renderItemStuff(event);
        }
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenerator(), (int)1);
        LogHelper.info("SimpleCore API Loading Complete!");
    }

    private void addVanillaTabs() {
        LogHelper.verbose("Adding vanilla tabs to ContentRegistry");
        ContentRegistry.registerPlugin(vanilla);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78030_b, "tabBlock", ContentCategories.CreativeTab.GENERAL);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78038_k, "tabBrewing", ContentCategories.CreativeTab.GENERAL);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78037_j, "tabCombat", ContentCategories.CreativeTab.GENERAL);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78031_c, "tabDecorations", ContentCategories.CreativeTab.GENERAL);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78039_h, "tabFood", ContentCategories.CreativeTab.GENERAL);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78035_l, "tabMaterials", ContentCategories.CreativeTab.GENERAL);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78026_f, "tabMisc", ContentCategories.CreativeTab.GENERAL);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78028_d, "tabRedstone", ContentCategories.CreativeTab.GENERAL);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78040_i, "tabTools", ContentCategories.CreativeTab.GENERAL);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78029_e, "tabTransport", ContentCategories.CreativeTab.GENERAL);
    }

    public static void tabPreInit() {
        LogHelper.verbose("Creating tabs");
        if (APISettings.tabs.asBoolean()) {
            simpleBlocks = new SimpleTab(plugin, "SimpleBlocks", ContentCategories.CreativeTab.BLOCKS);
            if (APISettings.separateTabs.asBoolean()) {
                simpleDecorations = new SimpleTab(plugin, "SimpleDecorations", ContentCategories.CreativeTab.DECORATIONS);
                simpleMaterials = new SimpleTab(plugin, "SimpleMaterials", ContentCategories.CreativeTab.MATERIALS);
                simpleTools = new SimpleTab(plugin, "SimpleTools", ContentCategories.CreativeTab.TOOLS);
                simpleCombat = new SimpleTab(plugin, "SimpleCombat", ContentCategories.CreativeTab.COMBAT);
            }
        }
    }

    public static void setTabIcons(List<Item> iconItemsList) {
        if (!iconsSet) {
            iconsSet = true;
            if (APISettings.tabs.asBoolean()) {
                simpleBlocks.setIcon(iconItemsList.get(0));
                if (APISettings.separateTabs.asBoolean()) {
                    simpleDecorations.setIcon(iconItemsList.get(1));
                    simpleMaterials.setIcon(iconItemsList.get(2));
                    simpleTools.setIcon(iconItemsList.get(3));
                    simpleCombat.setIcon(iconItemsList.get(4));
                }
            }
        }
    }

    public static void addBowRenderDetails(Plugin plugin, Item bow) {
        ArrayList list = Lists.newArrayList();
        list.add(plugin);
        list.add(bow);
        bowRenderList.add(list);
    }

    static {
        plugin = new Plugin("simplecore", "SimpleCore API");
        vanilla = new Plugin("minecraft", "Minecraft");
        bowRenderList = Lists.newArrayList();
        iconsSet = false;
    }
}

