/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.content.items;

import alexndr.api.config.types.ConfigArmor;
import alexndr.api.helpers.game.TooltipHelper;
import alexndr.api.registry.ContentCategories;
import alexndr.api.registry.ContentRegistry;
import alexndr.api.registry.Plugin;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class SimpleArmor
extends ItemArmor {
    private final ItemArmor.ArmorMaterial material;
    protected Plugin plugin;
    protected ContentCategories.Item category = ContentCategories.Item.ARMOR;
    protected ConfigArmor entry;
    protected Slots slot;
    protected String type;
    protected String texturePath;
    private List<String> toolTipStrings = Lists.newArrayList();

    public SimpleArmor(Plugin plugin, ItemArmor.ArmorMaterial material, Slots slot) {
        super(material, 1, slot.slotNumber);
        this.plugin = plugin;
        this.material = material;
        this.slot = slot;
    }

    public SimpleArmor setUnlocalizedName(String armorName) {
        super.func_77655_b(armorName);
        GameRegistry.registerItem((Item)this, (String)armorName);
        ContentRegistry.registerItem(this.plugin, (Item)this, armorName, this.category);
        return this;
    }

    public ConfigArmor getConfigEntry() {
        return this.entry;
    }

    public SimpleArmor setConfigEntry(ConfigArmor entry) {
        this.entry = entry;
        return this;
    }

    public SimpleArmor setType(String armorType) {
        this.type = armorType;
        this.setArmorTexturePath(this.plugin.getModId(), armorType, this.slot.slotNumber);
        return this;
    }

    public SimpleArmor addToolTip(String toolTip) {
        TooltipHelper.addTooltipToItem((Item)this, toolTip);
        return this;
    }

    public SimpleArmor addToolTip(String toolTip, EnumChatFormatting color) {
        TooltipHelper.addTooltipToItem((Item)this, color + StatCollector.func_74838_a((String)toolTip));
        return this;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.material.customCraftingMaterial == repair.func_77973_b() ? true : super.func_82789_a(toRepair, repair);
    }

    public String getArmorTexture(ItemStack itemstack, Entity entity, int slot, String layer) {
        return this.texturePath;
    }

    public void setArmorTexturePath(String modId, String type, int slotNumber) {
        switch (slotNumber) {
            case 0: {
                this.texturePath = modId + ":textures/models/armor/" + type + "_layer_1.png";
                break;
            }
            case 1: {
                this.texturePath = modId + ":textures/models/armor/" + type + "_layer_1.png";
                break;
            }
            case 2: {
                this.texturePath = modId + ":textures/models/armor/" + type + "_layer_2.png";
                break;
            }
            case 3: {
                this.texturePath = modId + ":textures/models/armor/" + type + "_layer_1.png";
            }
        }
    }

    public static enum Slots {
        HELM(0),
        CHEST(1),
        LEGS(2),
        BOOTS(3);

        int slotNumber;

        private Slots(int slotNumber) {
            this.slotNumber = slotNumber;
        }
    }
}

