/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.config.types;

import alexndr.api.logger.LogHelper;

public class ConfigValue {
    private boolean active = false;
    private String name;
    private String dataType = "";
    private String currentValue;
    private String defaultValue;

    public ConfigValue(String name) {
        this.name = name;
    }

    public ConfigValue assignToValue(ConfigValue value) {
        value = this;
        return value;
    }

    public boolean isActive() {
        return this.active;
    }

    public ConfigValue setActive() {
        this.active = true;
        return this;
    }

    public ConfigValue setActive(boolean active) {
        this.active = active;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getDataType() {
        return this.dataType;
    }

    public ConfigValue setDataType(String dataType) {
        this.dataType = dataType;
        return this;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public ConfigValue setCurrentValue(String currentValue) {
        this.currentValue = currentValue;
        return this;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public ConfigValue setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public boolean asBoolean() {
        try {
            return Boolean.parseBoolean(this.getCurrentValue());
        }
        catch (Exception e) {
            LogHelper.warning("Could not parse ConfigValue " + this.name + " as a boolean. Value is: " + this.currentValue);
            return false;
        }
    }

    public Double asDouble() {
        return Double.parseDouble(this.getCurrentValue());
    }

    public Float asFloat() {
        return Float.valueOf(Float.parseFloat(this.getCurrentValue()));
    }

    public Integer asInt() {
        return Integer.parseInt(this.getCurrentValue());
    }
}

