/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.config.types;

import alexndr.api.config.types.ConfigEntry;
import alexndr.api.config.types.ConfigValue;
import alexndr.api.registry.ContentRegistry;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;

public class ConfigItem
extends ConfigEntry {
    private List<ConfigValue> valuesList = Lists.newArrayList();
    private ConfigValue stackSize = new ConfigValue("StackSize").setCurrentValue("64");
    private ConfigValue creativeTab = new ConfigValue("CreativeTab");
    private ConfigValue render3D = new ConfigValue("Render3D").setCurrentValue("true");
    private ConfigValue smeltingXP = new ConfigValue("SmeltingXP");
    private ConfigValue beaconPayment = new ConfigValue("BeaconPayment");

    public ConfigItem(String name, String category) {
        super(name, category);
        this.valuesList.addAll(Lists.newArrayList((Object[])new ConfigValue[]{this.stackSize, this.creativeTab, this.render3D, this.smeltingXP, this.beaconPayment}));
        super.setValuesList(this.valuesList);
    }

    @Override
    public List<ConfigValue> getValuesList() {
        return this.valuesList;
    }

    @Override
    public void setValuesList(List<ConfigValue> valuesList) {
        this.valuesList = valuesList;
    }

    @Override
    public ConfigValue createNewValue(String valueName) {
        ConfigValue value = new ConfigValue(valueName);
        value.setActive();
        this.valuesList.add(value);
        return value;
    }

    @Override
    public ConfigItem createNewValue(String valueName, String dataType, String currentValue, String defaultValue) {
        ConfigValue value = new ConfigValue(valueName);
        value.setActive();
        value.setDataType(dataType);
        value.setCurrentValue(currentValue);
        value.setDefaultValue(defaultValue);
        this.valuesList.add(value);
        return this;
    }

    @Override
    public ConfigValue getValueByName(String valueName) {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(valueName)) continue;
            return value;
        }
        return null;
    }

    public int getStackSize() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.stackSize.getName())) continue;
            return Integer.parseInt(value.getCurrentValue());
        }
        return 64;
    }

    public ConfigItem setStackSize(int stackSize) {
        this.stackSize.setActive().setDataType("@I").setCurrentValue("" + stackSize).setDefaultValue("" + stackSize);
        return this;
    }

    public CreativeTabs getCreativeTab() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.creativeTab.getName()) || !ContentRegistry.doesTabExist(value.getCurrentValue())) continue;
            return ContentRegistry.getTab(value.getCurrentValue());
        }
        return null;
    }

    public ConfigItem setCreativeTab(String tabName) {
        this.creativeTab.setActive().setDataType("@S").setCurrentValue(tabName).setDefaultValue(tabName);
        return this;
    }

    public boolean getRender3D() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.render3D.getName())) continue;
            return Boolean.parseBoolean(value.getCurrentValue());
        }
        return true;
    }

    public ConfigItem setRender3D(boolean render3d) {
        this.render3D.setActive().setDataType("@B").setCurrentValue("" + render3d).setDefaultValue("" + render3d);
        return this;
    }

    public float getSmeltingXP() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.smeltingXP.getName())) continue;
            return Float.parseFloat(value.getCurrentValue());
        }
        return 0.0f;
    }

    public ConfigItem setSmeltingXP(float smeltingXP) {
        this.smeltingXP.setActive().setDataType("@F").setCurrentValue("" + smeltingXP).setDefaultValue("" + smeltingXP);
        return this;
    }

    public boolean getBeaconPayment() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.beaconPayment.getName())) continue;
            return Boolean.parseBoolean(value.getCurrentValue());
        }
        return false;
    }

    public ConfigItem setBeaconPayment(boolean beaconPayment) {
        this.beaconPayment.setActive().setDataType("@B").setCurrentValue("" + beaconPayment).setDefaultValue("" + beaconPayment);
        return this;
    }
}

