/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.blocks.BlockCurtainsClosed;
import com.mrcrayfish.furniture.blocks.BlockCurtainsOpen;
import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import com.mrcrayfish.furniture.init.FurnitureItems;
import com.mrcrayfish.furniture.util.CollisionHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockCurtains
extends BlockFurniture {
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", Type.class);

    public BlockCurtains(Material material) {
        super(material);
        this.func_149711_c(0.5f);
        this.func_149672_a(Block.field_149775_l);
        if (!this.isOpen()) {
            this.func_149713_g(255);
        } else {
            this.func_149713_g(0);
        }
    }

    public boolean func_149751_l() {
        return true;
    }

    public void func_180654_a(IBlockAccess blockAccess, BlockPos pos) {
        IBlockState state = blockAccess.func_180495_p(pos);
        int rotation = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        float[] bounds = CollisionHelper.fixRotation(rotation, 0.875f, 0.0f, 1.0f, 1.0f);
        this.func_149676_a(bounds[0], 0.0f, bounds[1], bounds[2], 1.0f, bounds[3]);
    }

    public void func_180638_a(World world, BlockPos pos, IBlockState state, AxisAlignedBB mask, List list, Entity collidingEntity) {
        int rotation = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        float[] bounds = CollisionHelper.fixRotation(rotation, 0.875f, 0.0f, 1.0f, 1.0f);
        this.func_149676_a(bounds[0], 0.0f, bounds[1], bounds[2], 1.0f, bounds[3]);
        super.func_180638_a(world, pos, state, mask, list, collidingEntity);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.isOpen()) {
            return worldIn.func_175656_a(pos, FurnitureBlocks.curtains_closed.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)));
        }
        return worldIn.func_175656_a(pos, FurnitureBlocks.curtains.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (this.isOpen()) {
            boolean right_closed;
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            IBlockState left_block = worldIn.func_180495_p(pos.func_177972_a(facing.func_176735_f()));
            IBlockState right_block = worldIn.func_180495_p(pos.func_177972_a(facing.func_176746_e()));
            boolean left_open = left_block.func_177230_c() instanceof BlockCurtainsOpen && ((EnumFacing)left_block.func_177229_b((IProperty)FACING)).equals((Object)facing);
            boolean right_open = right_block.func_177230_c() instanceof BlockCurtainsOpen && ((EnumFacing)right_block.func_177229_b((IProperty)FACING)).equals((Object)facing);
            boolean left_closed = left_block.func_177230_c() instanceof BlockCurtainsClosed && ((EnumFacing)left_block.func_177229_b((IProperty)FACING)).equals((Object)facing);
            boolean bl = right_closed = right_block.func_177230_c() instanceof BlockCurtainsClosed && ((EnumFacing)right_block.func_177229_b((IProperty)FACING)).equals((Object)facing);
            if (right_open) {
                if (left_open) {
                    return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.NONE));
                }
                if (left_closed) {
                    return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.LEFT_CLOSED));
                }
                return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.RIGHT_OPEN));
            }
            if (left_open) {
                if (right_open) {
                    return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.NONE));
                }
                if (right_closed) {
                    return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.RIGHT_CLOSED));
                }
                return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.LEFT_OPEN));
            }
            if (right_closed) {
                if (left_closed) {
                    return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.BOTH));
                }
                if (left_open) {
                    return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.LEFT));
                }
                return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.RIGHT));
            }
            if (left_closed) {
                if (right_closed) {
                    return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.BOTH));
                }
                if (right_open) {
                    return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.LEFT_CLOSED));
                }
                return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.LEFT));
            }
            return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.DEFAULT));
        }
        return state;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return FurnitureItems.itemCurtains;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos) {
        return new ItemStack(FurnitureItems.itemCurtains);
    }

    @Override
    protected BlockState func_180661_e() {
        return this.isOpen() ? new BlockState((Block)this, new IProperty[]{FACING, TYPE}) : super.func_180661_e();
    }

    public abstract boolean isOpen();

    public static enum Type implements IStringSerializable
    {
        DEFAULT,
        LEFT,
        RIGHT,
        LEFT_OPEN,
        RIGHT_OPEN,
        LEFT_CLOSED,
        RIGHT_CLOSED,
        BOTH,
        NONE;


        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }
}

