/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.JustEnoughItems;
import mezz.jei.api.IItemBlacklist;
import mezz.jei.config.Config;
import mezz.jei.util.Log;
import net.minecraft.item.ItemStack;

public class ItemBlacklist
implements IItemBlacklist {
    @Nonnull
    private final Set<String> itemBlacklist = new HashSet<String>();

    @Override
    public void addItemToBlacklist(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            Log.error("Null itemStack", new NullPointerException());
            return;
        }
        String uid = Internal.getStackHelper().getUniqueIdentifierForStack(itemStack);
        this.itemBlacklist.add(uid);
        JustEnoughItems.getProxy().resetItemFilter();
    }

    @Override
    public void removeItemFromBlacklist(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            Log.error("Null itemStack", new NullPointerException());
            return;
        }
        String uid = Internal.getStackHelper().getUniqueIdentifierForStack(itemStack);
        this.itemBlacklist.remove(uid);
        JustEnoughItems.getProxy().resetItemFilter();
    }

    @Override
    public boolean isItemBlacklisted(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            Log.error("Null itemStack", new NullPointerException());
            return false;
        }
        List<String> uids = Internal.getStackHelper().getUniqueIdentifiersWithWildcard(itemStack);
        for (String uid : uids) {
            if (!this.itemBlacklist.contains(uid)) continue;
            return true;
        }
        return Config.isItemOnConfigBlacklist(itemStack);
    }
}

