/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.RecipeRegistry;
import mezz.jei.gui.ItemListOverlay;
import mezz.jei.gui.RecipesGui;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.input.InputHandler;
import mezz.jei.util.Translator;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Mouse;

public class GuiEventHandler {
    @Nonnull
    private static final String showRecipesText = Translator.translateToLocal("jei.tooltip.show.recipes");
    @Nullable
    private ItemListOverlay itemListOverlay;
    @Nullable
    private InputHandler inputHandler;
    @Nullable
    private GuiContainer previousGui = null;

    public void setItemListOverlay(@Nullable ItemListOverlay itemListOverlay) {
        if (this.itemListOverlay != null && this.itemListOverlay.isOpen()) {
            this.itemListOverlay.close();
        }
        this.itemListOverlay = itemListOverlay;
    }

    @SubscribeEvent
    public void onGuiInit(@Nonnull GuiScreenEvent.InitGuiEvent.Post event) {
        if (this.itemListOverlay == null) {
            return;
        }
        if (event.gui instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)event.gui;
            this.itemListOverlay.initGui((GuiScreen)guiContainer);
            RecipesGui recipesGui = new RecipesGui();
            this.inputHandler = new InputHandler(recipesGui, this.itemListOverlay);
        }
    }

    @SubscribeEvent
    public void onGuiOpen(@Nonnull GuiOpenEvent event) {
        if (this.itemListOverlay == null) {
            return;
        }
        if (event.gui instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)event.gui;
            if (this.previousGui != guiContainer) {
                this.previousGui = guiContainer;
                if (this.itemListOverlay.isOpen()) {
                    this.itemListOverlay.close();
                }
            }
        } else if (!(event.gui instanceof RecipesGui) && this.itemListOverlay.isOpen()) {
            this.itemListOverlay.close();
        }
    }

    @SubscribeEvent
    public void onDrawBackgroundEventPost(@Nonnull GuiScreenEvent.BackgroundDrawnEvent event) {
        if (this.itemListOverlay != null && this.itemListOverlay.isOpen()) {
            this.itemListOverlay.updateGui(event.gui);
            this.itemListOverlay.drawScreen(event.gui.field_146297_k, event.getMouseX(), event.getMouseY());
        }
    }

    @SubscribeEvent
    public void onDrawScreenEventPost(@Nonnull GuiScreenEvent.DrawScreenEvent.Post event) {
        if (this.itemListOverlay == null) {
            return;
        }
        if (event.gui instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)event.gui;
            RecipeRegistry recipeRegistry = Internal.getRuntime().getRecipeRegistry();
            if (recipeRegistry.getRecipeClickableArea(guiContainer, event.mouseX - guiContainer.field_147003_i, event.mouseY - guiContainer.field_147009_r) != null) {
                TooltipRenderer.drawHoveringText(guiContainer.field_146297_k, showRecipesText, event.mouseX, event.mouseY);
            }
        }
        if (this.itemListOverlay.isOpen()) {
            this.itemListOverlay.drawTooltips(event.gui.field_146297_k, event.mouseX, event.mouseY);
        }
    }

    @SubscribeEvent
    public void onClientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (this.itemListOverlay == null || event.phase == TickEvent.Phase.END) {
            return;
        }
        if (this.itemListOverlay.isOpen()) {
            this.itemListOverlay.handleTick();
        }
    }

    @SubscribeEvent
    public void onGuiKeyboardEvent(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (this.inputHandler != null && this.inputHandler.handleKeyEvent()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiMouseEvent(GuiScreenEvent.MouseInputEvent.Pre event) {
        int y;
        int x;
        GuiScreen guiScreen = event.gui;
        if (this.inputHandler != null && this.inputHandler.handleMouseEvent(guiScreen, x = Mouse.getEventX() * guiScreen.field_146294_l / guiScreen.field_146297_k.field_71443_c, y = guiScreen.field_146295_m - Mouse.getEventY() * guiScreen.field_146295_m / guiScreen.field_146297_k.field_71440_d - 1)) {
            event.setCanceled(true);
        }
    }
}

